% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_similarity.R
\name{calculate_similarity}
\alias{calculate_similarity}
\title{SNV profile similarity calculations}
\usage{
calculate_similarity(data, similarity = NULL, a = 1, b = 5)
}
\arguments{
\item{data}{The input SNV data dataframe.}

\item{similarity}{Optional dataframe to add results to.}

\item{a}{Similarity score parameter a (integer).}

\item{b}{Similarity score parameter b (integer).}
}
\value{
A dataframe with summary statistics.
}
\description{
Calculate the similarity statistics for SNV profile
 comparisons.
}
\details{
This function calculates various summary statistics and sample similarities
for a given profile comparison dataframe. It returns a small dataframe with
the overall similarity score (whose parameters `a` and `b` can be adjusted
in the function call), total SNV data, the concordance of the data
and the sample names in question. This dataframe can also be given to the 
function, in which case it will simply add another row for the current
samples, facilitating downstream aggregate analyses.
}
\examples{
# Load test data
data(test_comparison)

# Calculate similarities
similarity <- calculate_similarity(test_comparison)

# Add another row of summary statistics
calculate_similarity(test_comparison, similarity = similarity)
}
