% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{binarize_bam}
\alias{binarize_bam}
\title{Binarize the bam files}
\usage{
binarize_bam(
  inputdir,
  cellmarkfiletable,
  chromsizefile,
  binsize = 200,
  outputdir
)
}
\arguments{
\item{inputdir}{A string. The dirctory of the bam files.}

\item{cellmarkfiletable}{A string. The path to the input files table. Only}

\item{chromsizefile}{A string. The path to the chromosomes sizes file.}

\item{binsize}{An integer. The number in bp used to generate binarized files.}

\item{outputdir}{A string. The path to a directory where output will be
written.}
}
\value{
NULL. Write files to the outputdir
}
\description{
Transform the aligned reads into a binary format.
}
\examples{
# locate input and output files
inputdir <- system.file("extdata", package = "bamsignals")
cellmarkfiletable <- system.file('extdata',
                                 'cell_mark_table.tsv',
                                 package = 'segmenter')
chromsizefile <- system.file('extdata/CHROMSIZES',
                             'hg18.txt',
                              package = 'chromhmmData')
outputdir <- tempdir()

# run command
binarize_bam(inputdir,
             chromsizefile = chromsizefile,
             cellmarkfiletable = cellmarkfiletable,
             outputdir = outputdir)

# show output files
list.files(outputdir, pattern = '*_binary.txt')

}
\seealso{
Binarize binarize_bed
}
