% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{log2FC}
\alias{log2FC}
\title{log2FC}
\usage{
log2FC(
  x,
  fromAssay = NULL,
  controls,
  by = NULL,
  isLog = NULL,
  agFun = rowMeans,
  toAssay = "log2FC",
  pseudocount = 1L,
  ndigits = 2
)
}
\arguments{
\item{x}{A numeric matrix, or a `SummarizedExperiment` object}

\item{fromAssay}{The assay to use if `x` is a `SummarizedExperiment`}

\item{controls}{A vector of which samples should be used as controls for
foldchange calculations.}

\item{by}{An optional vector indicating groups/batches by which the controls
will be averaged to calculate per-group foldchanges.}

\item{isLog}{Logical; whether the data is log-transformed. If NULL, will
attempt to figure it out from the data and/or assay name}

\item{agFun}{Aggregation function for the baseline (default rowMeans)}

\item{toAssay}{The name of the assay in which to save the output. If left to
the default value, both a log2FC assay as well as a scaled log2FC assay
(scaled by unit-variance, but not centered) will be saved in the object.}

\item{pseudocount}{If the origin assay is not log-transformed, `pseudocount`
will be added to the values before calculating a log-transformation. This
prevents infinite fold-changes and moderates them.}

\item{ndigits}{Number of digits after the decimal of the log2FC (and
scaledLFC).}
}
\value{
An object of same class as `x`; if a `SummarizedExperiment`, will
have the additional assay named from `toAssay`.
}
\description{
Generates log2(foldchange) matrix/assay, eventually on a per-batch fashion.
}
\examples{
log2FC( matrix(rnorm(40), ncol=4), controls=1:2 )

}
