% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/glmpca.R
\name{GLMPCA}
\alias{GLMPCA}
\alias{GLMPCA,SummarizedExperiment-method}
\alias{GLMPCA,matrix-method}
\alias{GLMPCA,Matrix-method}
\title{Generalized principal components analysis for non-normally distributed
  data}
\usage{
GLMPCA(object, ...)

\S4method{GLMPCA}{SummarizedExperiment}(object, L, assay = "counts", ...)

\S4method{GLMPCA}{matrix}(object, L, ...)

\S4method{GLMPCA}{Matrix}(object, L, ...)
}
\arguments{
\item{object}{A \code{\link{SingleCellExperiment}} or
\link{SummarizedExperiment} object. Alternatively, a matrix-like object
of non-negative integer counts (such as a sparse \code{\link{Matrix}}).}

\item{...}{further arguments passed to \code{\link[glmpca]{glmpca}}}

\item{L}{the desired number of latent dimensions (integer).}

\item{assay}{a character or integer specifying which assay to use for GLM-PCA
(default = 'counts'). Ignored if \code{object} is a matrix.}
}
\value{
The original \code{SingleCellExperiment} or
  \code{SummarizedExperiment} object with the GLM-PCA results added to the
  \code{metadata} slot. If the original input was a
  \code{SingleCellExperiment}, then a new \code{reducedDim} element called
  \code{"GLMPCA"} will be added, representing the GLM-PCA \code{factors}. If
  the input was a matrix, output matches that of
  \code{\link[glmpca]{glmpca}}.
}
\description{
This function implements the GLM-PCA dimensionality reduction
  method for high-dimensional count data. This is a wrapper for
  \code{\link[glmpca]{glmpca}}.
}
\examples{
ncells <- 100
u <- matrix(rpois(20000, 5), ncol=ncells)
sce <- SingleCellExperiment::SingleCellExperiment(assays=list(counts=u))
GLMPCA(sce, L = 2)

}
