% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScpModel-Workflow.R
\name{scplainer}
\alias{scplainer}
\title{scplainer: linear models to understand mass
spectrometry-based single-cell proteomics data}
\description{
\emph{scplainer}, standing for SCP-based Linear modelling Approach for
Interpretable aNd Explorable Results, is a principled and
standardised approach for extracting meaningful insights from SCP
data. At its core, the approach performs statistical modelling
using linear regression.

The workflow starts from a \link{SingleCellExperiment} object
containing SCP data. The data is assumed to be
\strong{log-transformed}. We advise to perform cell and feature quality
control to avoid that failed or outlying cells/feature distort the
results. We also recommend starting at the precursor or the
peptide-level, but the workflow also allows protein-level data.
Similarly, the workflow is robust against for missing values, but
it also allows for data where missing values are imputed.

To learn how to import your data, we suggest reading the vignette:
\code{vignette("read_scp", package = "scp")}

To learn how to process your data, we suggest reading the vignette:
\code{vignette("scp", package = "scp")}

\strong{Outline of the workflow}
\enumerate{
\item \link{scpModel-Workflow}: performs the data modelling and filtering
using linear regression.
\item \link{ScpModel-VarianceAnalysis}: investigate the contribution of
each model variable to the data
\item \link{ScpModel-DifferentialAnalysis}: assess the statistical
significance of the differences observed between group of
samples of interest.
\item \link{ScpModel-ComponentAnalysis}: visually explore the data
captured by each model variable.
}

Once the data are modelled and explored, the filtered, normalised
and batch-corrected data can be retrieved for further downstream
analysis, such as clustering or trajectory inference.

You can find a demonstration of the \emph{scplainer} workflow in a
dedicated vignette:
\code{vignette("scp_data_modelling", package = "scp")}
}
\references{
scplainer: using linear models to understand mass
spectrometry-based single-cell proteomics data Christophe
Vanderaa, Laurent Gatto bioRxiv 2023.12.14.571792; doi:
https://doi.org/10.1101/2023.12.14.571792.
}
\author{
Christophe Vanderaa, Laurent Gatto
}
