% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{normalizeSCP}
\alias{normalizeSCP}
\title{Normalize single-cell proteomics (SCP) data}
\usage{
normalizeSCP(object, i, name = "normAssay", method, ...)
}
\arguments{
\item{object}{An object of class \code{QFeatures}.}

\item{i}{A numeric vector or a character vector giving the index
or the name, respectively, of the assay(s) to be processed.}

\item{name}{A \code{character(1)} naming the new assay name. Defaults is
are \code{normAssay}.}

\item{method}{\code{character(1)} defining the normalisation method to
apply. See Details.`}

\item{...}{Additional parameters passed to
\code{\link[MsCoreUtils:normalize]{MsCoreUtils::normalizeMethods()}}.}
}
\value{
A \code{QFeatures} object with an additional assay containing the
normalized data.
}
\description{
This function normalises an assay in a \code{QFeatures} according to
the supplied method (see Details). The normalized data is added as
a new assay
}
\details{
The \code{method} parameter in \code{normalize} can be one of \code{"sum"},
\code{"max"}, \code{"center.mean"}, \code{"center.median"}, \code{"div.mean"},
\code{"div.median"}, \code{"diff.meda"}, \verb{"quantiles}", \verb{"quantiles.robust}"
or \code{"vsn"}. The \code{\link[MsCoreUtils:normalize]{MsCoreUtils::normalizeMethods()}} function returns
a vector of available normalisation methods.
\itemize{
\item For \code{"sum"} and \code{"max"}, each feature's intensity is divided by
the maximum or the sum of the feature respectively. These two
methods are applied along the features (rows).
\item \code{"center.mean"} and \code{"center.median"} center the respective
sample (column) intensities by subtracting the respective column
means or medians. \code{"div.mean"} and \code{"div.median"} divide by the
column means or medians. These are equivalent to \code{sweep}ing the
column means (medians) along \code{MARGIN = 2} with \code{FUN = "-"} (for
\code{"center.*"}) or \code{FUN = "/"} (for \code{"div.*"}).
\item \code{"diff.median"} centers all samples (columns) so that they all
match the grand median by subtracting the respective columns
medians differences to the grand median.
\item Using \code{"quantiles"} or \code{"quantiles.robust"} applies (robust)
quantile normalisation, as implemented in
\code{\link[preprocessCore:normalize.quantiles]{preprocessCore::normalize.quantiles()}} and
\code{\link[preprocessCore:normalize.quantiles.robust]{preprocessCore::normalize.quantiles.robust()}}. \code{"vsn"} uses the
\code{\link[vsn:vsn2]{vsn::vsn2()}} function. Note that the latter also glog-transforms
the intensities. See respective manuals for more details and
function arguments.
}

For further details and examples about normalisation, see
\code{\link[MsCoreUtils:normalize]{MsCoreUtils::normalize_matrix()}}.
}
\examples{

data("scp1")
scp1
normalizeSCP(scp1, i = "proteins", name = "normproteins", 
             method = "center.mean")

}
\seealso{
\link[QFeatures:QFeatures-processing]{QFeatures::normalize} for more details about \code{normalize}
}
