% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_metrics.R
\name{pep2qvalue}
\alias{pep2qvalue}
\title{Compute q-values}
\usage{
pep2qvalue(object, i, groupBy, PEP, rowDataName = "qvalue")
}
\arguments{
\item{object}{A \code{QFeatures} object}

\item{i}{A \code{numeric()} or \code{character()} vector indicating from
which assays the \code{rowData} should be taken.}

\item{groupBy}{A \code{character(1)} indicating the variable name in
the \code{rowData} that contains the grouping variable, for
instance to compute protein FDR. When \code{groupBy} is not missing,
the best feature approach is used to compute the PEP per group,
meaning that the smallest PEP is taken as the PEP of the group.}

\item{PEP}{A \code{character(1)} indicating the variable names in the
\code{rowData} that contains the PEPs. Since, PEPs are probabilities, the
variable must be contained in (0, 1).}

\item{rowDataName}{A \code{character(1)} giving the name of the new
variable in the \code{rowData} where the computed FDRs will be
stored. The name cannot already exist in any of the assay
\code{rowData}.}
}
\value{
A \code{QFeatures} object.
}
\description{
This function computes q-values from the posterior error
probabilities (PEPs). The functions takes the PEPs from the given
assay's \code{rowData} and adds a new variable to it that contains the
computed q-values.
}
\details{
The q-value of a feature (PSM, peptide, protein) is the minimum
FDR at which that feature will be selected upon filtering
(Savitski et al.). On the other hand, the feature PEP is the
probability that the feature is wrongly matched and hence can be
seen as a local FDR (Kall et al.). While filtering on PEP is
guaranteed to control for FDR, it is usually too conservative.
Therefore, we provide this function to convert PEP to q-values.

We compute the q-value of a feature as the average of the PEPs
associated to PSMs that have equal or greater identification
confidence (so smaller PEP). See Kall et al. for a visual
interpretation.

We also allow inference of q-values at higher level, for instance
computing the protein q-values from PSM PEP. This can be performed
by supplying the \code{groupBy} argument. In this case, we adopt the
best feature strategy that will take the best (smallest) PEP for
each group (Savitski et al.).
}
\examples{
data("scp1")
scp1 <- pep2qvalue(scp1,
                   i = 1,
                   groupBy = "protein",
                   PEP = "dart_PEP",
                   rowDataName = "qvalue_protein")
## Check results
rowData(scp1)[[1]][, c("dart_PEP", "qvalue_protein")]

}
\references{
Käll, Lukas, John D. Storey, Michael J. MacCoss, and William
Stafford Noble. 2008. “Posterior Error Probabilities and False
Discovery Rates: Two Sides of the Same Coin.” Journal of Proteome
Research 7 (1): 40–44.

Savitski, Mikhail M., Mathias Wilhelm, Hannes Hahne, Bernhard
Kuster, and Marcus Bantscheff. 2015. “A Scalable Approach for
Protein False Discovery Rate Estimation in Large Proteomic Data
Sets.” Molecular & Cellular Proteomics: MCP 14 (9): 2394–2404.
}
