% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_metrics.R
\name{medianCVperCell}
\alias{medianCVperCell}
\title{Compute the median coefficient of variation (CV) per cell}
\usage{
medianCVperCell(
  object,
  i,
  groupBy,
  nobs = 5,
  na.rm = TRUE,
  colDataName = "MedianCV",
  norm = "none",
  ...
)
}
\arguments{
\item{object}{A \code{QFeatures} object}

\item{i}{A \code{numeric()} or \code{character()} vector indicating from
which assays the \code{rowData} should be taken.}

\item{groupBy}{A \code{character(1)} indicating the variable name in
the \code{rowData} that contains the feature grouping.}

\item{nobs}{An \code{integer(1)} indicating how many observations
(features) should at least be considered for computing the CV.
Since no CV can be computed for less than 2 observations,
\code{nobs} should at least be 2.}

\item{na.rm}{A \code{logical(1)} indicating whether missing data should
be removed before computation.}

\item{colDataName}{A \code{character(1)} giving the name of the new
variable in the \code{colData} where the computed CVs will be
stored. The name cannot already exist in the \code{colData}.}

\item{norm}{A \code{character()} of normalization methods that will be
sequentially applied to each feature (row) in each assay.
Available methods and additional
information about normalization can be found in
\link[MsCoreUtils:normalize]{MsCoreUtils::normalizeMethods}. You can also specify
\code{norm = "SCoPE2"} to reproduce the normalization performed
before computing the CVs as suggested by Specht et al.
\code{norm = "none"} will not normalize the data (default)}

\item{...}{Additional arguments that are passed to the
normalization method.}
}
\value{
A \code{QFeatures} object.
}
\description{
The function computes for each cell the median CV and stores them
accordingly in the \code{colData} of the \code{QFeatures} object. The CVs in
each cell are computed from a group of features. The grouping is
defined by a variable in the \code{rowData}. The function can be
applied to one or more assays, as long as the samples (column
names) are not duplicated. Also, the user can supply a minimal
number of observations required to compute a CV to avoid that CVs
computed on too few observations influence the distribution within
a cell. The quantification matrix can be optionally normalized
before computing the CVs. Multiple normalizations are possible.
}
\details{
A new column is added to the \code{colData} of the object. The samples
(columns) that are not present in the selection \code{i} will get
assigned an NA.
}
\examples{
data("scp1")
scp1 <- filterFeatures(scp1, ~ !is.na(Proteins))
scp1 <- medianCVperCell(scp1, 
                        i = 1:3,
                        groupBy = "Proteins",
                        nobs = 5,
                        na.rm = TRUE,
                        colDataName = "MedianCV",
                        norm = "div.median")
## Check results
hist(scp1$MedianCV)

}
\references{
Specht, Harrison, Edward Emmott, Aleksandra A. Petelski,
R. Gray Huffman, David H. Perlman, Marco Serra, Peter Kharchenko,
Antonius Koller, and Nikolai Slavov. 2021. “Single-Cell Proteomic
and Transcriptomic Analysis of Macrophage Heterogeneity Using
SCoPE2.” Genome Biology 22 (1): 50.
}
