% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{lm_adjust}
\alias{lm_adjust}
\title{Linear Adjustment Normalization}
\usage{
lm_adjust(log_expr, design_mat, batch = NULL, weights = NULL)
}
\arguments{
\item{log_expr}{matrix. The log gene expression (genes in row, samples in
columns).}

\item{design_mat}{matrix. The design matrix (usually the result of
make_design).}

\item{batch}{factor. A factor with the batch information, identifying batch
effect to be removed.}

\item{weights}{matrix. A matrix of weights.}
}
\value{
The corrected log gene expression.
}
\description{
Given a matrix with log expression values and a design matrix, this function
fits a linear model and removes the effects of the batch factor
as well as of the linear variables encoded in W.
}
\details{
The function assumes that the columns of the design matrix
  corresponding to the variable for which expression needs to be adjusted,
  start with either the word "batch" or the letter "W" (case sensitive). Any
  other covariate (including the intercept) is kept.
}
\examples{

set.seed(141)
bio = as.factor(rep(c(1,2),each = 2))
batch = as.factor(rep(c(1,2),2))
design_mat = make_design(bio,batch, W = NULL)

log_expr = matrix(rnorm(20),ncol = 4)
adjusted_log_expr = lm_adjust(log_expr = log_expr,
  design_mat = design_mat,
  batch = batch)

}
