% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ziber.R
\name{impute_expectation}
\alias{impute_expectation}
\title{Imputation of zero abundance based on general zero-inflated model}
\usage{
impute_expectation(expression, impute_args)
}
\arguments{
\item{expression}{the data matrix (genes in rows, cells in columns)}

\item{impute_args}{arguments for imputation (see details)}
}
\value{
the imputed expression matrix.
}
\description{
This function is used to impute the data, weighted by probability of data
coming from the zero-inflation part of the distribution.
}
\details{
The imputation is carried out with the following formula: 
  y_{ij}* = y_{ij} * Pr( No Drop | y_{ij}) + mu_{i} * Pr( Drop | y_{ij}).
  
  impute_args must contain 2 elements: 1) p_nodrop = posterior probability
  of data not having resulted from drop-out  (genes in rows, cells in
  columns) 2) mu = expected expression of dropped data (genes in rows, cells
  in columns)
}
\examples{
mat <- matrix(rpois(1000, lambda = 3), ncol=10)
mat = mat * matrix(1-rbinom(1000, size = 1, prob = .01), ncol=10)

mu = matrix(rep(3/ppois(0,lambda = 3,lower.tail = FALSE),1000),ncol = 10)

p_false = 1 / ( 1 + ppois(0, lambda = 3, lower.tail = TRUE ) / 
    (0.01 * ppois(0, lambda = 3, lower.tail = FALSE) ) )

p_nodrop = matrix(rep(1-p_false,1000),ncol = 10)
p_nodrop[mat > 0] = 1

impute_args = list()
impute_args = list(mu = mu, p_nodrop = p_nodrop)

imat = impute_expectation(mat,impute_args = impute_args)

}
