% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/helper.R
\name{get_negconruv}
\alias{get_negconruv}
\alias{get_negconeval}
\alias{get_poscon}
\alias{get_negconruv,SconeExperiment-method}
\alias{get_negconeval,SconeExperiment-method}
\alias{get_poscon,SconeExperiment-method}
\title{Get Negative and Positive Controls}
\usage{
get_negconruv(x)

get_negconeval(x)

get_poscon(x)

\S4method{get_negconruv}{SconeExperiment}(x)

\S4method{get_negconeval}{SconeExperiment}(x)

\S4method{get_poscon}{SconeExperiment}(x)
}
\arguments{
\item{x}{an object of class \code{\link{SconeExperiment}}.}
}
\value{
NULL or a logical vector.

For \code{get_negconruv} the returned vector indicates which genes
  are negative controls to be used for RUV.

For \code{get_negconeval} the returned vector indicates which genes
  are negative controls to be used for evaluation.

For \code{get_poscon} the returned vector indicates which genes are 
  positive controls to be used for evaluation.
}
\description{
Get Negative and Positive Controls
}
\examples{
set.seed(42)
mat <- matrix(rpois(500, lambda = 5), ncol=10)
colnames(mat) <- paste("X", 1:ncol(mat), sep="")
obj <- SconeExperiment(mat,negcon_ruv = 1:50 \%in\% 1:10,
           negcon_eval = 1:50 \%in\% 11:20,
           poscon = 1:50 \%in\% 21:30)
negcon_ruv = get_negconruv(obj)
negcon_eval = get_negconeval(obj)
poscon = get_poscon(obj)

}
