% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDR.R
\name{plotDR}
\alias{plotDR}
\alias{plotUMAP}
\alias{plotPCA}
\title{Plot reduced dimensions.}
\usage{
plotDR(
  spe,
  dimred = NULL,
  dims = c(1, 2),
  group.by = NULL,
  feature = NULL,
  assay = "counts",
  cols = NULL,
  pt.shape = 16,
  pt.size = 1,
  pt.alpha = 0.6,
  label = NULL,
  label.x = NULL,
  label.y = NULL,
  cols.scale = NULL
)

plotUMAP(spe, dimred = "UMAP", ...)

plotPCA(spe, dimred = "PCA", ...)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{dimred}{Name of the reduced dimension in \link[SingleCellExperiment]{reducedDims}}

\item{dims}{Numeric vector length 2 for the dimensions to be plotted. Default to first two dimensions}

\item{group.by}{values to group points by. Must be in colData of spe.
If NULL, will try with 'cols' if available.}

\item{feature}{Feature to group polygons by. Must be in rownames(spe).}

\item{assay}{Name of assay to use for plotting feature.}

\item{cols}{Colour palette. Can be a vector of colours or a function
that accepts an integer n and return n colours.}

\item{pt.shape}{shape of points.}

\item{pt.size}{size of points.}

\item{pt.alpha}{alpha of points between 0 and 1.}

\item{label}{label for the legend}

\item{label.x}{label for the x-axis}

\item{label.y}{label for the y-axis}

\item{cols.scale}{vector of position for color if colors should not be
evenly positioned. See \link[ggplot2]{scale_color_gradientn}. Only applicable for continuous values.}

\item{...}{Additional arguments pass to plotDR}
}
\value{
A ggplot object.
}
\description{
plotDR is the main function for plotting reduced dimension. Others are
wrapper functions for convenience.
}
\examples{

data("xenium_bc_spe")
spe = runUMAP(spe)
plotDR(spe, group.by = "cell_type")

}
