% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorHeatmap.R
\name{plotCorHeatmap}
\alias{plotCorHeatmap}
\title{Plot model statistics using heatmap.}
\usage{
plotCorHeatmap(
  model.result,
  stats = c("cor.coef", "t", "p.Pos", "p.Neg"),
  roi = "all",
  cell.type = "all",
  silent = FALSE
)
}
\arguments{
\item{model.result}{A dataFrame object.}

\item{stats}{Character value. Choose either coefficient or t.
Coefficient by default.}

\item{roi}{Character value. By default is all. The specific
ROIs to be plotted.}

\item{cell.type}{Character value. By default is all. The cell types
to be plotted.}

\item{silent}{Do not draw the plot
(useful when using the gtable output).}
}
\value{
A pheatmap object.
}
\description{
Plot model statistics using heatmap.
}
\examples{

data("xenium_bc_spe")

coi <- c("Breast cancer", "Fibroblasts", "B cells", "T cells")

spe <- gridDensity(spe, coi = coi)

spe <- findROI(spe, coi = coi)

model_result <- corDensity(spe, roi = coi)

plotCorHeatmap(model_result$ROI)

}
