% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridDensity.R
\name{gridDensity}
\alias{gridDensity}
\title{Perform kernel density estimation on SpatialExperiment for
cell types of interest}
\usage{
gridDensity(
  spe,
  id = if (isVisium) NULL else "cell_type",
  coi = NULL,
  feature = NULL,
  assay = "counts",
  kernel = "gaussian",
  bandwidth = NULL,
  ngrid.x = NULL,
  grid.length.x = NULL,
  diggle = FALSE,
  grid.type = c("hex", "square"),
  isVisium = FALSE,
  filterToVisiumSpot = isVisium
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{id}{A character. The name of the column of colData(spe) containing
the cell type identifiers. Set to cell_type by default. Set to NULL for overall density.}

\item{coi}{A character vector of cell types of interest (COIs).
Default to all cell types.}

\item{feature}{Feature(s) to calculate density with. Must be in rownames(spe).}

\item{assay}{Name of assay to use for finding feature(s).}

\item{kernel}{The smoothing kernel. Options are "gaussian",
"epanechnikov", "quartic" or "disc". For hexagonal grid, only Gaussian is implemented}

\item{bandwidth}{The smoothing bandwidth. By default performing
automatic bandwidth selection using cross-validation using
function spatstat.explore::bw.diggle.}

\item{ngrid.x}{Number of grids in the x-direction. Ignored when
'grid.length.x' is specified. Default to NULL.}

\item{grid.length.x}{Grid length in the x-direction. If both
'ngrid.x' and 'grid.length.x' are NULL, then 'grid.length.x'
is set to 100 (micron) by default.}

\item{diggle}{Logical. If TRUE, use the Jones-Diggle improved edge
correction. See spatstat.explore::density.ppp() for details.}

\item{grid.type}{Type of grid can be either hexagon or square.}

\item{isVisium}{Logical. If TRUE, fit hexagonal grids to Visium spots by
replacing spatial coords with array rows & array cols.}

\item{filterToVisiumSpot}{Logical. If TRUE, filter grid polygons to only
those with a Visium spot underneath.}
}
\value{
A SpatialExperiment object. Grid density estimates for
all cell type of interest are stored in spe@metadata$grid_density.
Grid information is stored in spe@metadata$grid_info
}
\description{
Perform kernel density estimation on SpatialExperiment for
cell types of interest
}
\examples{

data("xenium_bc_spe")

spe <- gridDensity(spe)

}
