% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran.R
\name{globalMoran}
\alias{globalMoran}
\title{Calculate global Moran for 1 to 2 variables.}
\usage{
globalMoran(
  spe,
  data1,
  data2 = data1[],
  at = c("grid", "cell"),
  nbrs_name = NULL,
  permutations = 999,
  seed = 123456789,
  cpu_threads = 6
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{data1}{Numeric vector 1. Must be same length as
nrow(spe@metadata$grid_density) or spatialCoords(spe), depending on 'at'.}

\item{data2}{Numeric vector 2 for bivariate local Moran. Must be same length as data1.}

\item{at}{Option of grid or cell for where to look for neighbour list}

\item{nbrs_name}{Name of the neighbour list in \code{spe@metadata$grid[[at]]}
for Moran's I}

\item{permutations}{Number of permutations for p-value.}

\item{seed}{Integer. For random permutations.}

\item{cpu_threads}{(optional) The number of cpu threads used for parallel
LISA computation}
}
\value{
List with global lisa, p.value, and vector of permuted lisa.
}
\description{
Calculate global Moran for 1 to 2 variables.
}
\examples{
data("xenium_bc_spe")

## At grid.
spe <- gridDensity(spe, coi = "Breast cancer")
dat <- spe@metadata$grid_density$density_breast_cancer
spe <- findNbrsGrid(spe)
res <- globalMoran(spe,data1 = dat,at="grid")
res$lisa
## At cell.
dat <- as.numeric(spe$cell_type=="Breast cancer")
spe <- findNbrsSpatial(spe,k=10)
res <- globalMoran(spe,data1 = dat,at="cell")
res$lisa
}
