% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeDensityHex.R
\name{computeDensityHex}
\alias{computeDensityHex}
\title{Perform kernel density estimation on SpatialExperiment}
\usage{
computeDensityHex(
  xy,
  kernel = c("gaussian"),
  bandwidth = NULL,
  weights = NULL,
  ngrid.x = NULL,
  xlim = NULL,
  ylim = NULL,
  diggle = FALSE,
  gridInfo = FALSE
)
}
\arguments{
\item{xy}{A numeric matrix of spatial coordinates.}

\item{kernel}{The smoothing kernel. Options are gaussian, epanechnikov,
quartic or disc. ONLY GAUSSIAN IS IMPLEMENTED}

\item{bandwidth}{The smoothing bandwidth. By default performing automatic
bandwidth selection using cross-validation using function
spatstat.explore::bw.diggle.}

\item{weights}{Optional weights to be attached to the points.}

\item{ngrid.x}{Number of grids in the x-direction.}

\item{xlim}{The range of the x-coordinates of the image.}

\item{ylim}{The range of the y-coordinates of the image.}

\item{diggle}{Logical. If TRUE, use the Jones-Diggle improved edge
correction. See spatstat.explore::density.ppp() for details.}

\item{gridInfo}{Logical. If TRUE, then the grid information is also returned.}
}
\value{
Output from spatstat.explore::density.ppp.
}
\description{
Perform kernel density estimation on SpatialExperiment
}
