% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hexbin_feature_plus.R
\name{plot_hexbin_feature_plus}
\alias{plot_hexbin_feature_plus}
\title{Plot of gene expression and meta data of single cell data in
bivariate hexagon cells.}
\usage{
plot_hexbin_feature_plus(
  sce,
  col,
  mod = "RNA",
  type,
  feature,
  action,
  colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  expand_hull = 3,
  ...
)
}
\arguments{
\item{sce}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{col}{A string referring to the name of one column in the meta data of
sce by which to colour the hexagons.}

\item{mod}{A string referring to the name of the modality used for plotting.
For RNA modality use "RNA". For other modalities use name of alternative
object for the \code{\link[SingleCellExperiment]{SingleCellExperiment}}
object.}

\item{type}{A string referring to the type of assay in the
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object.}

\item{feature}{A string referring to the name of one feature.}

\item{action}{A string specifying how gene expression of observations in
 binned  hexagon cells are to be summarized. Possible actions are
\code{prop_0}, \code{mode}, \code{mean} and
 \code{median} (see details).}

\item{colors}{A vector of strings specifying which colors to use for plotting
the different levels in the selected column of the meta data.}

\item{title}{A string containing the title of the plot.}

\item{xlab}{A string containing the title of the x axis.}

\item{ylab}{A string containing the title of the y axis.}

\item{expand_hull}{A numeric value determining the expansion of the line
marking different clusters.}

\item{...}{Additional arguments passed on to
\code{\link{ggforce}{geom_mark_hull}}.}
}
\value{
A \code{\link{ggplot2}{ggplot}} object.
}
\description{
Plot of gene expression and meta data of single cell data in
bivariate hexagon cells.
}
\details{
This function plots any gene expresssion in the hexagon cell
  representation calculated with \code{\link{make_hexbin}} as well as at the
  same time representing outlines of clusters. The chosen gene
  expression is summarized by one of four actions \code{prop_0},
  \code{mode}, \code{mean} and \code{median}:

  \describe{
    \item{\code{prop_0}}{Returns the proportion of observations in the bin
     greater than 0. The associated meta data column needs to be numeric.}
    \item{\code{mode}}{Returns the mode of the observations in the bin. The
     associated meta data column needs to be numeric.}
    \item{\code{mean}}{Returns the mean of the observations in the bin. The
     associated meta data column needs to be numeric.}
     \item{\code{median}}{Returns the median of the observations in the bin.
     The associated meta data column needs to be numeric.}
  }
}
\examples{
# For SingleCellExperiment object
library(TENxPBMCData)
library(scater)
tenx_pbmc3k <- TENxPBMCData(dataset = "pbmc3k")
rm_ind <- calculateAverage(tenx_pbmc3k) < 0.1
tenx_pbmc3k <- tenx_pbmc3k[!rm_ind, ]
tenx_pbmc3k <- logNormCounts(tenx_pbmc3k)
tenx_pbmc3k <- runPCA(tenx_pbmc3k)
tenx_pbmc3k <- make_hexbin(tenx_pbmc3k, 10, dimension_reduction = "PCA")
tenx_pbmc3k$random <- factor(sample(1:3, ncol(tenx_pbmc3k), replace = TRUE))
plot_hexbin_feature_plus(tenx_pbmc3k,
    col = "random", type = "counts",
    feature = "ENSG00000135250", action = "mean"
)
}
