% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pagoda.cluster.cells}
\alias{pagoda.cluster.cells}
\title{Determine optimal cell clustering based on the genes driving the significant aspects}
\usage{
pagoda.cluster.cells(tam, varinfo, method = "ward.D",
  include.aspects = FALSE, verbose = 0, return.details = FALSE)
}
\arguments{
\item{tam}{result of pagoda.top.aspects() call}

\item{varinfo}{result of pagoda.varnorm() call}

\item{method}{clustering method ('ward.D' by default)}

\item{include.aspects}{whether the aspect patterns themselves should be included alongside with the individual genes in calculating cell distance}

\item{verbose}{0 or 1 depending on level of desired verbosity}

\item{return.details}{Boolean of whether to return just the hclust result or a list containing the hclust result plus the distance matrix and gene values}
}
\value{
hclust result
}
\description{
Determines cell clustering (hclust result) based on a weighted correlation of genes
underlying the top aspects of transcriptional heterogeneity. Branch orientation is optimized
if 'cba' package is installed.
}
\examples{
data(pollen)
cd <- clean.counts(pollen)
\donttest{
knn <- knn.error.models(cd, k=ncol(cd)/4, n.cores=10, min.count.threshold=2, min.nonfailed=5, max.model.plots=10)
varinfo <- pagoda.varnorm(knn, counts = cd, trim = 3/ncol(cd), max.adj.var = 5, n.cores = 1, plot = FALSE)
pwpca <- pagoda.pathway.wPCA(varinfo, go.env, n.components=1, n.cores=10, n.internal.shuffles=50)
tam <- pagoda.top.aspects(pwpca, return.table = TRUE, plot=FALSE, z.score=1.96)  # top aspects based on GO only
hc <- pagoda.cluster.cells(tam, varinfo)
plot(hc)
}

}

