% Generated by roxygen2: do not edit by hand
\docType{data}
\name{pdacData}
\alias{pdacData}
\title{Tissue-CyCIF data of Pancreatic Ductal Adenocarcinoma (PDAC)}
\format{
A data frame with 158159 rows and 3 variables:
  \describe{
    \item{frame}{10x frame from t-CyCIF imaging.  Used to identify tissue type of cell.}
    \item{Xt}{Cartesian x-coordinate of cell across entire tissue sample (across all frames).}
    \item{Yt}{Cartesian y-coordinate of cell across entire tissue sample (across all frames)}
  } 
}
\source{
  \describe{
     Shortened version of t-CyCIF single-cell data of Pancreatic Ductal Adenocarcinoma (PDAC)
     resection specimen from \emph{Lin et. al} with only the cartesian 
     coordinates and frames each cell is in present.
     
  }
  
  Entire dataset can be downloaded from
  \url{http://lincs.hms.harvard.edu/wordpress/wp-content/uploads/2017/05/rawdata_Figure78_PDAC.zip}
}
\usage{
data(pdacData)
}
\description{
{
Single-cell resolution of 4 cellular compartments in a human
Pancreatic Dual Adenocarcinoma sample that spans across three distinct
tissues: the pancreas, small intestine, and tumor.  Contains cartesian
coordinates of each cell along with the frame it was identified from in t-CyCIF
imaging.}
}

\references{
{Lin et al. (2018) eLife 2018;7:e31657} (\href{https://elifesciences.org/articles/31657}{eLife})

}
