% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanning.R
\name{getMatchTypes}
\alias{getMatchTypes}
\title{getMatchTypes}
\usage{
getMatchTypes(x, seed, checkWobble = TRUE)
}
\arguments{
\item{x}{A character vector of short sequences.}

\item{seed}{A 7 or 8 nucleotides string indicating the seed (5' to 3'
sequence of the target RNA). If of length 7, an "A" will be appended.}

\item{checkWobble}{Whether to flag wobbled sites}
}
\value{
A factor of match types.
}
\description{
Given a seed and a set of sequences matching it, returns the type of match.
}
\examples{
x <- c("AACACTCCAG","GACACTCCGC","GTACTCCAT","ACGTACGTAC")
getMatchTypes(x, seed="ACACTCCA")
}
