% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KdModels.R
\name{getKdModel}
\alias{getKdModel}
\title{getKdModel}
\usage{
getKdModel(kd, mirseq = NULL, name = NULL, conservation = NA_integer_, ...)
}
\arguments{
\item{kd}{A data.frame containing the log_kd per 12-mer sequence, or the
path to a text/csv file containing such a table. Should contain the columns
'log_kd', '12mer' (or 'X12mer'), and eventually 'mirseq' (if the `mirseq`
argument is NULL) and 'mir' (if the `name` argument is NULL).}

\item{mirseq}{The miRNA (cDNA) sequence.}

\item{name}{The name of the miRNA.}

\item{conservation}{The conservation level of the miRNA. See
`scanMiR:::.conservation_levels()` for possible values.}

\item{...}{Any additional information to be saved with the model.}
}
\value{
An object of class `KdModel`.
}
\description{
getKdModel
}
\examples{
kd <- dummyKdData()
mod <- getKdModel(kd=kd, mirseq="TTAATGCTAATCGTGATAGGGGTT", name="my-miRNA")
}
