% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanMiRserver.R
\name{scanMiRserver}
\alias{scanMiRserver}
\title{scanMiRserver}
\usage{
scanMiRserver(
  annotations = list(),
  modlists = NULL,
  gc.time = Inf,
  maxCacheSize = 10 * 10^6,
  BP = SerialParam()
)
}
\arguments{
\item{annotations}{A named list of \code{\link{ScanMiRAnno}} object.}

\item{modlists}{A named list of `KdModelList` objects. If omitted, will
fetch it from the annotation objects.}

\item{gc.time}{The number of microseconds after which a garbage collect
should be performed.}

\item{maxCacheSize}{Maximum cache size in bytes.}

\item{BP}{BPPARAM for multithreading}
}
\value{
A shiny server function
}
\description{
Server function for the scanMiR shiny app. Most users are expected to use
\code{\link{scanMiRApp}} instead.
}
\examples{
# we'd normally fetch a real annotation:
# anno <- ScanMiRAnno("Rnor_6")
# here we'll use a fake one:
anno <- ScanMiRAnno("fake")
srv <- scanMiRserver(list(fake=anno))
}
