% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotElbow.R
\name{plotElbow}
\alias{plotElbow}
\title{This function takes a SingleCellExperiment object and variants of interest as
 input and plots an elbow plot to perform k-means later.}
\usage{
plotElbow(sce, variants.of.interest)
}
\arguments{
\item{sce}{A SingleCellExperiment object containing the relevant data.}

\item{variants.of.interest}{A vector specifying the variants of interest.}
}
\value{
ggplot object with elbow plot.
}
\description{
This function takes a SingleCellExperiment object and variants of interest as
 input and plots an elbow plot to perform k-means later.
}
\examples{
# Assume `sce` is a SingleCellExperiment object with variants in altExp().
sce_filtered <- readRDS(system.file("extdata", "sce_filtered_demo.rds",
package = "scafari"))
plotElbow(
    sce = sce_filtered,
    variants.of.interest = c(
        "FLT3:chr13:28610183:A/G",
        "KIT:chr4:55599436:T/C",
        "TP53:chr17:7577427:G/A",
        "TET2:chr4:106158216:G/A"
    )
)
}
