% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAmpliconDistribution.R
\name{plotAmpliconDistribution}
\alias{plotAmpliconDistribution}
\title{Plot Distribution of Amplicons}
\usage{
plotAmpliconDistribution(sce)
}
\arguments{
\item{sce}{A SingleCellExperiment object that contains the assay data,
including amplicon information to be plotted.}
}
\value{
A ggplot object representing the distribution of amplicons.
}
\description{
This function generates a plot to visualize the distribution of amplicons
within a `SingleCellExperiment` object.
}
\examples{
# Assume `sce` is a SingleCellExperiment object with 'counts' assay.
h5_file_path <- system.file("extdata", "demo.h5", package = "scafari")
h5 <- h5ToSce(h5_file_path)
sce <- h5$sce_amp
plotAmpliconDistribution(sce)

}
