% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetClone.R
\name{subsetClones}
\alias{subsetClones}
\title{Subset The Product of combineTCR() or combineBCR()}
\usage{
subsetClones(input.data, name, variables = NULL)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}} or
\code{\link[=combineBCR]{combineBCR()}}.}

\item{name}{The column header/name to use for subsetting.}

\item{variables}{The values to subset by, must be in the in the variable.}
}
\value{
list of contigs that have been filtered for the name parameter
}
\description{
This function allows for the subsetting of the product of
\code{\link[=combineTCR]{combineTCR()}} or \code{\link[=combineBCR]{combineBCR()}}
by the name of the individual list element.
}
\examples{
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))
subset <- subsetClones(combined, name = "sample", variables = c("P17B"))

}
\concept{Loading_and_Processing_Contigs}
