% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/positionalProperty.R
\name{positionalProperty}
\alias{positionalProperty}
\title{Plot Positional Physicochemical Property Analysis}
\usage{
positionalProperty(
  input.data,
  chain = "TRB",
  group.by = NULL,
  order.by = NULL,
  aa.length = 20,
  method = "atchleyFactors",
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}}, \code{\link[=combineBCR]{combineBCR()}}, or
\code{\link[=combineExpression]{combineExpression()}}}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL},
\code{IGK}, \code{Light} (for both light chains), or \code{both} (for TRA/B and Heavy/Light).}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed
by list element or active identity in the case of single-cell objects.}

\item{order.by}{A character vector defining the desired order of elements
of the \code{group.by} variable. Alternatively, use \code{alphanumeric} to sort groups
automatically.}

\item{aa.length}{The maximum length of the CDR3 amino acid sequence.}

\item{method}{Character string (one of the supported names)
Defaults to \code{"atchleyFactors"}, but includes: \code{"crucianiProperties"},
\code{"FASGAI"}, \code{"kideraFactors"}, \code{"MSWHIM"}, \code{"ProtFP"}, \code{"stScales"},
\code{"tScales"}, \code{"VHSE"}, \code{"zScales"}}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any \link[grDevices:palettes]{hcl.pals}}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object displaying property by amino acid position.
If \code{exportTable = TRUE}, a matrix of the raw data is returned.
}
\description{
This function analyzes the physicochemical properties of amino acids at each
position along the CDR3 sequence. It calculates the mean property value and
the 95\% confidence interval for each position across one or more groups,
visualizing the results as a line plot with a confidence ribbon.
}
\details{
The function uses one of several established physicochemical property scales
to convert amino acid sequences into numerical vectors. More information for
the individual methods can be found at the following citations:

\strong{atchleyFactors:} \href{https://pubmed.ncbi.nlm.nih.gov/15851683/}{citation}

\strong{crucianiProperties:} \href{https://analyticalsciencejournals.onlinelibrary.wiley.com/doi/abs/10.1002/cem.856}{citation}

\strong{FASGAI:} \href{https://pubmed.ncbi.nlm.nih.gov/18318694/}{citation}

\strong{kideraFactors:} \href{https://link.springer.com/article/10.1007/BF01025492}{citation}

\strong{MSWHIM:} \href{https://pubs.acs.org/doi/10.1021/ci980211b}{citation}

\strong{ProtFP:} \href{https://pubmed.ncbi.nlm.nih.gov/24059694/}{citation}

\strong{stScales:} \href{https://pubmed.ncbi.nlm.nih.gov/19373543/}{citation}

\strong{tScales:} \href{https://www.sciencedirect.com/science/article/abs/pii/S0022286006006314}{citation}

\strong{VHSE:} \href{https://pubmed.ncbi.nlm.nih.gov/15895431/}{citation}

\strong{zScales:} \href{https://pubmed.ncbi.nlm.nih.gov/9651153/}{citation}
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Using positionalProperty()
positionalProperty(combined, 
                   chain = "TRB",
                   method = "atchleyFactors", 
                   aa.length = 20)
                   
}
\author{
Florian Bach, Nick Borcherding
}
\concept{Summarize_Repertoire}
