% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlightClones.R
\name{highlightClones}
\alias{highlightClones}
\title{Highlighting Specific Clones}
\usage{
highlightClones(
  sc.data,
  cloneCall = c("gene", "nt", "aa", "strict"),
  sequence = NULL
)
}
\arguments{
\item{sc.data}{The single-cell object to attach after
\code{\link[=combineExpression]{combineExpression()}}}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{sequence}{The specific sequence or sequence to highlight}
}
\value{
Single-cell object object with new meta data column
for indicated clones
}
\description{
Use a specific clonal sequence to highlight on top of the dimensional
reduction in single-cell object.
}
\examples{
# Getting the combined contigs
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Getting a sample of a Seurat object
scRep_example  <- get(data("scRep_example"))

# Using combineExpresion()
scRep_example  <- combineExpression(combined, 
                                    scRep_example)

# Using highlightClones()
scRep_example   <- highlightClones(scRep_example, 
                                   cloneCall= "aa", 
                                   sequence = c("CVVSDNTGGFKTIF_CASSVRRERANTGELFF"))

}
\concept{SC_Functions}
