% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineContigs.R
\name{combineBCR}
\alias{combineBCR}
\title{Combine B Cell Receptor Contig Data}
\usage{
combineBCR(
  input.data,
  samples = NULL,
  ID = NULL,
  chain = "both",
  sequence = "nt",
  dist_type = "levenshtein",
  dist_mat = "BLOSUM80",
  normalize = "length",
  gap_open = -10,
  gap_extend = -1,
  call.related.clones = TRUE,
  group.by = NULL,
  threshold = 0.85,
  cluster.method = "components",
  use.V = TRUE,
  use.J = TRUE,
  removeNA = FALSE,
  removeMulti = FALSE,
  filterMulti = TRUE,
  filterNonproductive = TRUE
)
}
\arguments{
\item{input.data}{List of filtered contig annotations or outputs from
\code{\link[=loadContigs]{loadContigs()}}.}

\item{samples}{A character vector of sample labels. Must be the same length
as the input list.}

\item{ID}{An optional character vector for additional sample identifiers.}

\item{chain}{The chain to use for clustering when \code{call.related.clones = TRUE}.
Passed to \code{clonalCluster()}. Default is \code{"both"}.}

\item{sequence}{The sequence type (\code{"nt"} or \code{"aa"}) to use for clustering.
Passed to \code{clonalCluster()}. Default is \code{"nt"}.}

\item{dist_type}{The distance metric to use. Options: \code{"levenshtein"} (default),
\code{"hamming"}, \code{"damerau"}, \code{"nw"} (Needleman-Wunsch), or \code{"sw"} (Smith-Waterman).}

\item{dist_mat}{The substitution matrix to use for alignment-based metrics
(\code{"nw"} or \code{"sw"}). Options include \code{"BLOSUM62"}, \code{"PAM30"}, etc.}

\item{normalize}{Method for normalizing distances. Options: \code{"none"} (default),
\code{"maxlen"}, or \code{"length"}.}

\item{gap_open}{Penalty for opening a gap in alignment metrics (default: -10).}

\item{gap_extend}{Penalty for extending a gap in alignment metrics (default: -1).}

\item{call.related.clones}{Logical. If \code{TRUE}, uses \code{clonalCluster()} to
identify related clones based on sequence similarity. If \code{FALSE}, defines
clones by the exact V-gene and CDR3 amino acid sequence.}

\item{group.by}{The column header used for to group clones.
If (`NULL``), clusters will be calculated across samples.}

\item{threshold}{The similarity threshold passed to \code{clonalCluster()} if
\code{call.related.clones = TRUE}. See \code{?clonalCluster} for details.}

\item{cluster.method}{The clustering algorithm to use. Defaults to \code{"components"},
which finds connected subgraphs.}

\item{use.V}{Logical. If \code{TRUE}, sequences must share the same V gene to be
clustered together.}

\item{use.J}{Logical. If \code{TRUE}, sequences must share the same J gene to be
clustered together.}

\item{removeNA}{This will remove any chain without values.}

\item{removeMulti}{Logical. If \code{TRUE}, removes cells that have more than
one distinct heavy or light chain after processing.}

\item{filterMulti}{Logical. If \code{TRUE}, filters multi-chain cells to retain
only the most abundant IGH and IGL/IGK chains.}

\item{filterNonproductive}{Logical. If \code{TRUE}, removes non-productive contigs
from the analysis.}
}
\value{
A list of data frames, where each data frame represents a sample.
Each row corresponds to a unique cell barcode, with columns detailing the
BCR chains and the assigned clone ID.
}
\description{
This function consolidates a list of BCR sequencing results to the level
of the individual cell barcodes. Using the samples and ID parameters,
the function will add the strings as prefixes to prevent issues with
repeated barcodes. The resulting new barcodes will need to match the
Seurat or SCE object in order to use, \code{\link[=combineExpression]{combineExpression()}}. Unlike
\code{\link[=combineTCR]{combineTCR()}}, combineBCR produces a column \code{CTstrict} based on the
edit distance clustering from \code{\link[=clonalCluster]{clonalCluster()}}. The \code{CTstrict} column
is formatted as \code{Heavy_Light} (underscore-separated) for downstream
compatibility. Connected clones are labeled with \code{cluster.X}, while
unconnected clones (singlets) are labeled with the V gene and CDR3
sequence (e.g., \verb{IGHV3-64.CAKSYS..._IGKV3-15.CQQYSN...}).
}
\examples{
# Data derived from the 10x Genomics intratumoral NSCLC B cells
BCR <- read.csv("https://www.borch.dev/uploads/contigs/b_contigs.csv")
combined <- combineBCR(BCR,
                       samples = "Patient1",
                       threshold = 0.85)

}
\concept{Loading_and_Processing_Contigs}
