% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalDiversity.R
\name{clonalDiversity}
\alias{clonalDiversity}
\title{Calculate Clonal Diversity}
\usage{
clonalDiversity(
  input.data,
  cloneCall = "strict",
  metric = "shannon",
  chain = "both",
  group.by = NULL,
  order.by = NULL,
  x.axis = NULL,
  exportTable = FALSE,
  palette = "inferno",
  n.boots = 100,
  return.boots = FALSE,
  skip.boots = FALSE,
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}},
\code{\link[=combineBCR]{combineBCR()}}, or \code{\link[=combineExpression]{combineExpression()}}.}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{metric}{The diversity metric to calculate. Must be a single string from
the list of available metrics (see Details).}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL},
\code{IGK}, \code{Light} (for both light chains), or \code{both} (for TRA/B and Heavy/Light).}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed
by list element or active identity in the case of single-cell objects.}

\item{order.by}{A character vector defining the desired order of elements
of the \code{group.by} variable. Alternatively, use \code{alphanumeric} to sort groups
automatically.}

\item{x.axis}{An additional metadata variable to group samples along the x-axis.}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}.}

\item{n.boots}{The number of bootstrap iterations to perform (default is 100).}

\item{return.boots}{If \code{TRUE}, returns all bootstrap values instead of the
mean. Automatically enables \code{exportTable}.}

\item{skip.boots}{If \code{TRUE}, disables downsampling and bootstrapping. The
metric will be calculated on the full dataset for each group. Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object visualizing the diversity metric, or a data.frame if
\code{exportTable = TRUE}.
}
\description{
This function calculates a specified diversity metric for samples or groups
within a dataset. To control for variations in library size, the function
can perform bootstrapping with downsampling. It resamples each group to the
size of the smallest group and calculates the diversity metric across
multiple iterations, returning the mean value.
}
\details{
The function operates by first splitting the dataset by the specified \code{group.by}
variable.

\strong{Downsampling and Bootstrapping:}
To make a fair comparison between groups of different sizes, diversity metrics
often require normalization. This function implements this by downsampling.
\enumerate{
\item It determines the number of clones in the smallest group.
\item For each group, it performs \code{n.boots} iterations (default = 100).
\item In each iteration, it randomly samples the clones (with replacement) down to
the size of the smallest group.
\item It calculates the selected diversity metric on this downsampled set.
\item The final reported diversity value is the mean of the results from all
bootstrap iterations.
}

This process can be disabled by setting \code{skip.boots = TRUE}.

Available Diversity Metrics (metric):
The function uses a registry of metrics imported from the immApex package.
You can select one of the following:
\itemize{
\item{\code{"shannon"}: Shannon's Entropy. See \code{\link[immApex]{shannon_entropy}}.}
\item{\code{"inv.simpson"}: Inverse Simpson Index. See \code{\link[immApex]{inv_simpson}}.}
\item{\code{"gini.simpson"}: Gini-Simpson Index. See \code{\link[immApex]{gini_simpson}}.}
\item{\code{"norm.entropy"}: Normalized Shannon Entropy. See \code{\link[immApex]{norm_entropy}}.}
\item{\code{"pielou"}: Pielou's Evenness (same as norm.entropy). See \code{\link[immApex]{pielou_evenness}}.}
\item{\code{"ace"}: Abundance-based Coverage Estimator. See \code{\link[immApex]{ace_richness}}.}
\item{\code{"chao1"}: Chao1 Richness Estimator. See \code{\link[immApex]{chao1_richness}}.}
\item{\code{"gini"}: Gini Coefficient for inequality. See \code{\link[immApex]{gini_coef}}.}
\item{\code{"d50"}: The number of top clones making up 50\% of the library. See \code{\link[immApex]{d50_dom}}.}
\item{\code{"hill0"}, \code{"hill1"}, \code{"hill2"}: Hill numbers of order 0, 1, and 2. See \code{\link[immApex]{hill_q}}.}
}
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list,
                       samples = c("P17B", "P17L", "P18B", "P18L",
                                   "P19B","P19L", "P20B", "P20L"))

# Calculate Shannon diversity, grouped by sample
clonalDiversity(combined, 
                cloneCall = "gene", 
                metric = "shannon")

# Calculate Inverse Simpson without bootstrapping
clonalDiversity(combined, 
                cloneCall = "aa", 
                metric = "inv.simpson", 
                skip.boots = TRUE)

}
\author{
Andrew Malone, Nick Borcherding, Nathan Vanderkraan
}
\concept{Visualizing_Clones}
