% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matPCs.R
\name{matPCs}
\alias{matPCs}
\title{matPCs function}
\usage{
matPCs(data, assay = NULL, percentVar = 0.8)
}
\arguments{
\item{data}{An expression matrix or a SingleCellExperiment object.}

\item{assay}{An assay to select if \code{data} is a SingleCellExperiment
object}

\item{percentVar}{The percentage of variance threshold. This is used to
select number of Principal Components.}
}
\value{
Dimensionally reduced matrix.
}
\description{
Performs PCA on a given matrix and returns a dimension reduced
matrix which captures at least 80\% (default) of overall variability.
}
\details{
This function performs PCA to reduce the dimension of the gene
expression matrix limited from 10 to 20 PCs.
}
\examples{
data("gse87795_subset_sce")

mat.expr <- gse87795_subset_sce

mat.pc <- matPCs(mat.expr, assay = "logNorm")

# to capture at least 70\% of overall variability in the dataset,
mat.dim.reduct.70 <- matPCs(mat.expr, assay = "logNorm", 0.7)

}
\author{
Pengyi Yang, Taiyun Kim
}
