% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_scPipeCPP.R
\name{sc_demultiplex}
\alias{sc_demultiplex}
\title{sc_demultiplex}
\usage{
sc_demultiplex(
  inbam,
  outdir,
  bc_anno,
  max_mis = 1,
  bam_tags = list(am = "YE", ge = "GE", bc = "BC", mb = "OX"),
  mito = "MT",
  has_UMI = TRUE,
  nthreads = 1
)
}
\arguments{
\item{inbam}{input bam file. This should be the output of
\code{sc_exon_mapping}}

\item{outdir}{output folder}

\item{bc_anno}{barcode annotation, first column is cell id, second column
is cell barcode sequence}

\item{max_mis}{maximum mismatch allowed in barcode. (default: 1)}

\item{bam_tags}{list defining BAM tags where mapping information is
stored.
\itemize{
  \item "am": mapping status tag
  \item "ge": gene id
  \item "bc": cell barcode tag
  \item "mb": molecular barcode tag
}}

\item{mito}{mitochondrial chromosome name.
This should be consistent with the chromosome names in the bam file.}

\item{has_UMI}{whether the protocol contains UMI (default: TRUE)}

\item{nthreads}{number of threads to use. (default: 1)}
}
\value{
no return
}
\description{
Process bam file by cell barcode,
output to outdir/count/[cell_id].csv.
the output contains information for all reads that can be mapped to exons.
including the gene id, UMI of that read and the distance to transcript end
position.
}
\examples{
data_dir="celseq2_demo"
barcode_annotation_fn = system.file("extdata", "barcode_anno.csv",
    package = "scPipe")
\dontrun{
# refer to the vignettes for the complete workflow
...
sc_demultiplex(file.path(data_dir, "out.map.bam"),
    data_dir,
    barcode_annotation_fn,has_UMI=FALSE)
...
}

}
