% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_atac_pipeline.R
\name{sc_atac_pipeline}
\alias{sc_atac_pipeline}
\title{A convenient function for running the entire pipeline}
\usage{
sc_atac_pipeline(
  r1,
  r2,
  bc_file,
  valid_barcode_file = "",
  id1_st = -0,
  id1_len = 16,
  id2_st = 0,
  id2_len = 16,
  rmN = TRUE,
  rmlow = TRUE,
  organism = NULL,
  reference = NULL,
  feature_type = NULL,
  remove_duplicates = FALSE,
  samtools_path = NULL,
  genome_size = NULL,
  bin_size = NULL,
  yieldsize = 1e+06,
  exclude_regions = TRUE,
  excluded_regions_filename = NULL,
  fix_chr = "none",
  lower = NULL,
  cell_calling = "filter",
  promoters_file = NULL,
  tss_file = NULL,
  enhs_file = NULL,
  gene_anno_file = NULL,
  min_uniq_frags = 3000,
  max_uniq_frags = 50000,
  min_frac_peak = 0.3,
  min_frac_tss = 0,
  min_frac_enhancer = 0,
  min_frac_promoter = 0.1,
  max_frac_mito = 0.15,
  report = TRUE,
  nthreads = 12,
  output_folder = NULL
)
}
\arguments{
\item{r1}{The first read fastq file}

\item{r2}{The second read fastq file}

\item{bc_file}{the barcode information, can be either in a \code{fastq} format (e.g. from 10x-ATAC) or
from a \code{.csv} file (here the barcode is expected to be on the second column). 
Currently, for the fastq approach, this can be a list of barcode files.}

\item{valid_barcode_file}{optional file path of the valid (expected) barcode sequences to be found in the bc_file (.txt, can be txt.gz). 
Must contain one barcode per line on the second column separated by a comma (default ="").
If given, each barcode from bc_file is matched against the barcode of
best fit (allowing a hamming distance of 1). If a FASTQ \code{bc_file} is provided, barcodes with a higher mapping quality, as given by
the fastq reads quality score are prioritised.}

\item{id1_st}{barcode start position (0-indexed) for read 1, which is an extra parameter that is needed if the
\code{bc_file} is in a \code{.csv} format.}

\item{id1_len}{barcode length for read 1, which is an extra parameter that is needed if the
\code{bc_file} is in a \code{.csv} format.}

\item{id2_st}{barcode start position (0-indexed) for read 2, which is an extra parameter that is needed if the
\code{bc_file} is in a \code{.csv} format.}

\item{id2_len}{barcode length for read 2, which is an extra parameter that is needed if the
\code{bc_file} is in a \code{.csv} format.}

\item{rmN}{ogical, whether to remove reads that contains N in UMI or cell barcode.}

\item{rmlow}{logical, whether to remove reads that have low quality barcode sequences.}

\item{organism}{The name of the organism e.g. hg38}

\item{reference}{The reference genome file}

\item{feature_type}{The feature type (either `genome_bin` or `peak`)}

\item{remove_duplicates}{Whether or not to remove duplicates (samtools is required)}

\item{samtools_path}{A custom path of samtools to use for duplicate removal}

\item{genome_size}{The size of the genome (used for the \code{cellranger} cell calling method)}

\item{bin_size}{The size of the bins for feature counting with the `genome_bin` feature type}

\item{yieldsize}{The number of reads to read in for feature counting}

\item{exclude_regions}{Whether or not the regions should be excluded}

\item{excluded_regions_filename}{The filename of the file containing the regions to be excluded}

\item{fix_chr}{Specify `none`, `exclude_regions`, `feature` or `both` to prepend the string "chr" to the start of the associated file}

\item{lower}{the lower threshold for the data if using the \code{emptydrops} function for cell calling.}

\item{cell_calling}{The desired cell calling method either \code{cellranger}, \code{emptydrops} or  \code{filter}}

\item{promoters_file}{The path of the promoter annotation file (if the specified organism isn't recognised)}

\item{tss_file}{The path of the tss annotation file (if the specified organism isn't recognised)}

\item{enhs_file}{The path of the enhs annotation file (if the specified organism isn't recognised)}

\item{gene_anno_file}{The path of the gene annotation file (gtf or gff3 format)}

\item{min_uniq_frags}{The minimum number of required unique fragments required for a cell (used for \code{filter} cell calling)}

\item{max_uniq_frags}{The maximum number of required unique fragments required for a cell (used for \code{filter} cell calling)}

\item{min_frac_peak}{The minimum proportion of fragments in a cell to overlap with a peak (used for \code{filter} cell calling)}

\item{min_frac_tss}{The minimum proportion of fragments in a cell to overlap with a tss (used for \code{filter} cell calling)}

\item{min_frac_enhancer}{The minimum proportion of fragments in a cell to overlap with a enhancer sequence (used for \code{filter} cell calling)}

\item{min_frac_promoter}{The minimum proportion of fragments in a cell to overlap with a promoter sequence (used for \code{filter} cell calling)}

\item{max_frac_mito}{The maximum proportion of fragments in a cell that are mitochondrial (used for \code{filter} cell calling)}

\item{report}{Whether or not a HTML report should be produced}

\item{nthreads}{The number of threads to use for alignment (sc_align) and demultiplexing (sc_atac_bam_tagging)}

\item{output_folder}{The path of the output folder}
}
\value{
None (invisible `NULL`)
}
\description{
A convenient function for running the entire pipeline
}
\examples{
data.folder <- system.file("extdata", package = "scPipe", mustWork = TRUE)
r1      <- file.path(data.folder, "small_chr21_R1.fastq.gz") 
r2      <- file.path(data.folder, "small_chr21_R3.fastq.gz") 

# Using a barcode fastq file:

# barcodes in fastq format
barcode_fastq      <- file.path(data.folder, "small_chr21_R2.fastq.gz") 

\dontrun{
sc_atac_pipeline(
  r1 = r1,
  r2 = r2,
  bc_file = barcode_fastq
)
}

}
