% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{remove_outliers}
\alias{remove_outliers}
\title{Remove outliers in \code{SingleCellExperiment}}
\usage{
remove_outliers(sce)
}
\arguments{
\item{sce}{a \code{SingleCellExperiment} object}
}
\value{
a \code{SingleCellExperiment} object without outliers
}
\description{
Removes outliers flagged by \code{detect_outliers()}
}
\examples{
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts = as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication
sce = detect_outlier(sce)
dim(sce)
sce = remove_outliers(sce)
dim(sce)

}
