% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_workflow.R
\name{create_report}
\alias{create_report}
\title{create_report}
\usage{
create_report(
  sample_name,
  outdir,
  r1 = "NA",
  r2 = "NA",
  outfq = "NA",
  read_structure = list(bs1 = 0, bl1 = 0, bs2 = 0, bl2 = 0, us = 0, ul = 0),
  filter_settings = list(rmlow = TRUE, rmN = TRUE, minq = 20, numbq = 2),
  align_bam = "NA",
  genome_index = "NA",
  map_bam = "NA",
  exon_anno = "NA",
  stnd = TRUE,
  fix_chr = FALSE,
  barcode_anno = "NA",
  max_mis = 1,
  UMI_cor = 1,
  gene_fl = FALSE,
  organism,
  gene_id_type
)
}
\arguments{
\item{sample_name}{sample name}

\item{outdir}{output folder}

\item{r1}{file path of read1}

\item{r2}{file path of read2 default to be NULL}

\item{outfq}{file path of the output of \code{sc_trim_barcode}}

\item{read_structure}{a list contains read structure configuration. For more help see `?sc_trim_barcode`}

\item{filter_settings}{a list contains read filter settings for more help see `?sc_trim_barcode`}

\item{align_bam}{the aligned bam file}

\item{genome_index}{genome index used for alignment}

\item{map_bam}{the mapped bam file}

\item{exon_anno}{the gff exon annotation used. Can have multiple files}

\item{stnd}{whether to perform strand specific mapping}

\item{fix_chr}{add `chr` to chromosome names, fix inconsistent names.}

\item{barcode_anno}{cell barcode annotation file path.}

\item{max_mis}{maximum mismatch allowed in barcode. Default to be 1}

\item{UMI_cor}{correct UMI sequence error: 0 means no correction, 1 means simple correction and merge UMI with distance 1.}

\item{gene_fl}{whether to remove low abundant gene count. Low abundant is defined as only one copy of one UMI for this gene}

\item{organism}{the organism of the data. List of possible names can be retrieved using the function
`listDatasets`from `biomaRt` package. (i.e `mmusculus_gene_ensembl` or `hsapiens_gene_ensembl`)}

\item{gene_id_type}{gene id type of the data A possible list of ids can be retrieved using the function `listAttributes` from `biomaRt` package.
the commonly used id types are `external_gene_name`, `ensembl_gene_id` or `entrezgene`}
}
\value{
no return
}
\description{
create an HTML report using data generated by proprocessing step.
}
\examples{
\dontrun{
create_report(sample_name="sample_001",
       outdir="output_dir_of_scPipe",
       r1="read1.fq",
       r2="read2.fq",
       outfq="trim.fq",
       read_structure=list(bs1=-1, bl1=2, bs2=6, bl2=8, us=0, ul=6),
       filter_settings=list(rmlow=TRUE, rmN=TRUE, minq=20, numbq=2),
       align_bam="align.bam",
       genome_index="mouse.index",
       map_bam="aligned.mapped.bam",
       exon_anno="exon_anno.gff3",
       stnd=TRUE,
       fix_chr=FALSE,
       barcode_anno="cell_barcode.csv",
       max_mis=1,
       UMI_cor=1,
       gene_fl=FALSE,
       organism="mmusculus_gene_ensembl",
       gene_id_type="ensembl_gene_id")
}

}
