% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual_static.R
\name{plot_af_coverage}
\alias{plot_af_coverage}
\title{QC plot: 2D scatter plot for coverage ~ AF}
\usage{
plot_af_coverage(
  mtmutObj,
  loc,
  model = NULL,
  p_threshold = NULL,
  alt_count_threshold = NULL,
  p_adj_method = NULL
)
}
\arguments{
\item{mtmutObj}{an object of class "mtmutObj".}

\item{loc}{a string of genome location, e.g. "chrM.200".}

\item{model}{a string of model name, one of "bb", "bm", "bi", the default value is "bb".}

\item{p_threshold}{a numeric value of p-value threshold, the default is 0.05.}

\item{alt_count_threshold}{a numeric value of alternative allele count threshold, the default is NULL, which means use the value in mtmutObj.}

\item{p_adj_method}{a string of p-value adjustment method, the default is FDR.}
}
\value{
a ggplot object.
}
\description{
QC plot: 2D scatter plot for coverage ~ AF
}
\examples{
## Use the example data
f <- system.file("extdata", "mini_dataset.tsv.gz", package = "scMitoMut")

## Create a temporary h5 file
## In real case, we keep the h5 in project folder for future use
f_h5_tmp <- tempfile(fileext = ".h5")

## Load the data with parse_table function
f_h5 <- parse_table(f, sep = "\t", h5_file = f_h5_tmp)

# open the h5f file
x <- open_h5_file(f_h5)

# run the model fit
run_model_fit(x)
x

# Filter the loci based on the model fit results
x <- filter_loc(x, min_cell = 5, model = "bb", p_threshold = 0.05, p_adj_method = "fdr")

# plot the locus profile for chrM.200
plot_af_coverage(x, "chrM.204")
}
