% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{parse_mgatk}
\alias{parse_mgatk}
\title{Load mtGATK output}
\usage{
parse_mgatk(dir, prefix, h5_file = "mut.h5")
}
\arguments{
\item{dir}{a string of the mtGATK output \code{final} fold.}

\item{prefix}{a string of the prefix of the mtGATK output directory.}

\item{h5_file}{a string of the output h5 file directory.}
}
\value{
a string of the output h5 file directory.
}
\description{
This function loads the mtGATK output and save it to a H5 file.
}
\examples{
## Use the allele count table data
f <- system.file("extdata", "mini_dataset.tsv.gz", package = "scMitoMut")
## Create a temporary h5 file
## In real case, we keep the h5 in project folder for future use
f_h5_tmp <- tempfile(fileext = ".h5")
## Load the data with parse_table function
f_h5 <- parse_table(f, sep = "\t", h5_file = f_h5_tmp)
f_h5
## Use the mgatk output
f <- system.file("extdata", "mini_mgatk_out", package = "scMitoMut")
f_h5_tmp <- tempfile(fileext = ".h5")
f_h5 <- parse_mgatk(paste0(f, "/final/"), prefix = "sample", h5_file = f_h5_tmp)
f_h5
x <- open_h5_file(f_h5)
x
##
}
