% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scReplicate.R
\name{scReplicate}
\alias{scReplicate}
\title{Create replicate matrix for scMerge algorithm}
\usage{
scReplicate(
  sce_combine,
  batch = NULL,
  kmeansK = NULL,
  exprs = "logcounts",
  hvg_exprs = "counts",
  marker = NULL,
  marker_list = NULL,
  replicate_prop = 1,
  cell_type = NULL,
  cell_type_match = FALSE,
  cell_type_inc = NULL,
  dist = "cor",
  WV = NULL,
  WV_marker = NULL,
  BPPARAM = SerialParam(),
  return_all = FALSE,
  BSPARAM = ExactParam(),
  plot_igraph = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{sce_combine}{A \code{SingleCellExperiment} object contains the batch-combined matrix with batch info in colData}

\item{batch}{A vector indicates the batch information for each cell in the batch-combined matrix.}

\item{kmeansK}{A vector indicates the kmeans's K for each batch, length of kmeansK needs to be the same as the number of batch.}

\item{exprs}{A string indicates the assay that are used for batch correction, default is logcounts}

\item{hvg_exprs}{A string indicates the assay that are used for highly variable genes identification, default is counts}

\item{marker}{A vector of markers, which will be used in calculation of mutual nearest cluster. If no markers input, highly variable genes will be used instead}

\item{marker_list}{A list of markers for each batch, which will be used in calculation of mutual nearest cluster.}

\item{replicate_prop}{A number indicating the ratio of cells that are included in pseudo-replicates, ranges from 0 to 1. Default to 1.}

\item{cell_type}{A vector indicates the cell type information for each cell in the batch-combined matrix. If it is \code{NULL}, pseudo-replicate procedure will be run to identify cell type.}

\item{cell_type_match}{Whether find mutual nearest cluster using cell type information}

\item{cell_type_inc}{A vector indicates the indices of the cells that will be used to supervise the pseudo-replicate procedure}

\item{dist}{The distance metrics that are used in the calculation of the mutual nearest cluster, default is Pearson correlation.}

\item{WV}{A vector indicates the wanted variation factor other than cell type info, such as cell stages.}

\item{WV_marker}{A vector indicates the markers of the wanted variation.}

\item{BPPARAM}{A \code{BiocParallelParam} class object from the \code{BiocParallel} package is used. Default is SerialParam().}

\item{return_all}{If \code{FALSE}, only return the replicate matrix.}

\item{BSPARAM}{A \code{BiocSingularParam} class object from the \code{BiocSingular} package is used. Default is ExactParam().}

\item{plot_igraph}{If \code{TRUE}, then during the un/semi-supervised scMErge, igraph plot will be displayed}

\item{verbose}{If \code{TRUE}, then all intermediate steps will be shown. Default to \code{FALSE}.}
}
\value{
If \code{return_all} is \code{FALSE}, return a replicate matrix.
If \code{return_sce} is \code{TRUE}, return the followings
\item{repMat }{replicate matrix}
\item{mnc }{mutual nearest cluster}
\item{replicate vector }{replicate vector}
\item{HVG }{highly variable genes used in scReplicate}

A cell-replicates mapping matrix.
Each row correspond to a cell from the input expression matrix, and each column correspond to a cell-cluster/cell-type.
An element of the mapping matrix is 1 if the scReplicate algorithm determines that this cell
should belong to that cell cluster and 0 otherwise.
}
\description{
Create replicate matrix for scMerge algorithm using un-/semi-/supervised approaches.
}
\examples{
## Loading example data
set.seed(1)
data('example_sce', package = 'scMerge')
scRep_result = scReplicate(
  sce_combine = example_sce,
  batch = example_sce$batch,
  kmeansK = c(3,3))

}
\author{
Yingxin Lin, Kevin Wang
}
