% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_mle.R
\name{bb_mle}
\alias{bb_mle}
\title{Beta binomial maximum likelihood estimation (BB MLE)}
\usage{
bb_mle(x, w = NULL, n_starts = 10, lower_thresh = 0.001)
}
\arguments{
\item{x}{An n x 2 data.table or matrix, where 1st column keeps total number
of trials and 2nd column number of successes, n is the total number of
samples.}

\item{w}{Vector with initial values of \code{alpha} and \code{beta}, if NULL the method
of moments is used to initialize them.}

\item{n_starts}{Total number of restarts when optimisation fails.}

\item{lower_thresh}{Threshold when to stop optimisation.}
}
\value{
A list with the following elements: \itemize{ \item{ \code{gamma}:
The overdispersion parameter. This is the most important parameter, since
it tells us if and how much overdispersion we observe in the data that
cannot be explained by the Binomial model.} \item {\code{mu}: The mean
parameter, i.e. success probability of the beta binomial.}
\item{\code{alpha}: Alpha parameter, when taking the different
parametrisation of the BB.} \item {\code{beta}: Beta parameter, when taking
the different parametrisation of the BB.} \item{\code{is_conv}: Logical,
whether or not the optimisation converged.} \item{\code{lrt}: The
likelihood ratio test statistic, for testing whether the Binomial or the
Beta-Binomial fit better the data.} \item{\code{chi2_test}: The p-value
from the Chi-squared test obtained from the LRT statistics.}
\item{\code{Z_score}: The Z score statistic proposed by Tarone (1979).
Seems more stable than LRT, in test whether we have overdispersion in our
data.} \item{\code{z_test}: The p-value obtain from the Z-score statistic.}
\item{\code{bb_ll}: Beta binomial log likelihood (used internally to
compute the LRT statistic and the BIC)} \item{\code{BIC_bb}: The Bayes
Information Criterion for beta binomial model} \item{\code{bin_ll}:
Binomial log likelihood (used internally to compute the LRT statistic and
the BIC.)} \item{\code{BIC_bin|}: The Bayes Information Criterion for binomial model}}
}
\description{
Maximum Likelihood Estimate (MLE) of Beta-Binomial (BB) model.
Some details about this model can be found on the following tutorial
\url{https://rpubs.com/cakapourani/beta-binomial}
}
\examples{
# Extract data from a single Feature
x <- scmet_dt$Y[Feature == "Feature_1", c("total_reads", "met_reads")]
fit_mle <- bb_mle(x)
}
\seealso{
\code{\link{scmet}}, \code{\link{scmet_differential}},
\code{\link{scmet_hvf_lvf}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
