% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_imputed_distance_diagnostic.R
\name{plot_imputed_distance_diagnostic}
\alias{plot_imputed_distance_diagnostic}
\title{Plot Imputed Distance Diagnostic}
\usage{
plot_imputed_distance_diagnostic(raw_sc_data, imp_sc_data, D)
}
\arguments{
\item{raw_sc_data}{A data frame containing the original single-cell Hi-C data
in scHiC Table format. The data frame should include columns for `region1`,
 `region2`, `Cell`, `Chr`, and `IF_i` for each of the "i" cells.}

\item{imp_sc_data}{A data frame containing the imputed single-cell Hi-C data
in scHiC Table format. The data frame should include columns for `region1`,
 `region2`, `Cell`, `Chr`, and `IF_i` for each of the "i" cells.}

\item{D}{An integer specifying the genomic distance for which to plot the
density curves of interaction frequencies. Genomic distance refers to the
distance between two regions in the genome, expressed in units of resolution
bins (e.g., D = (start2 - start1)/resolution).
For example, if the genomic regions are at positions 16,000,000
and 17,000,000 with a resolution of 1,000,000, then
 D = (17,000,000 - 16,000,000)/1,000,000 = 1.}
}
\value{
A ggplot2 object representing the density plot comparing the original
  and imputed interaction frequencies.
}
\description{
This function plots the distribution density curves of interaction
frequencies from original and imputed single-cell Hi-C data at a given
genomic distance.
}
\details{
The distance D represents how far apart two genomic loci are. Observations
indicate that chromatin interaction frequency (IF) in Hi-C data tends to
decrease as the genomic distance between two loci increases. It is assumed
that scHi-C interaction frequencies at the same distance share similar
statistical properties. To diagnose whether the imputed IF values retain
these statistical properties at each distance, the
`plot_imputed_distance_diagnostic()` function plots the density curves of
interaction frequencies from original and imputed single-cell Hi-C data for
a specified genomic distance.
}
\examples{
data("scHiC.table_MG_chr22")
## Impute data above
scHiC.table_MG_imp <- scHiCcompare_impute(scHiC.table = scHiC.table_MG_chr22)

# Call the function with this sparse matrix to generate the plot
plot_imputed_distance_diagnostic(
  raw_sc_data = scHiC.table_MG_chr22,
  imp_sc_data = scHiC.table_MG_imp, D = 1
)

}
