% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinb_simdata.R
\name{zinb_simdata}
\alias{zinb_simdata}
\title{Simulate Zero-Inflated Negative Binomial (ZINB) Count Matrices with
Sequencing Depth}
\usage{
zinb_simdata(
  n,
  p,
  B,
  mu_range,
  mu_noise,
  theta,
  pi,
  kmat = 1,
  depth_range = NA
)
}
\arguments{
\item{n}{Integer. Number of cells (samples) in each simulated matrix.}

\item{p}{Integer. Number of genes (features) in each simulated matrix.}

\item{B}{A symmetric binary adjacency matrix (0/1) defining gene-gene
connectivity. Row and column names correspond to gene names.}

\item{mu_range}{List of numeric vectors (length 2 each). Range of gene
expression means for each simulated matrix.}

\item{mu_noise}{Numeric vector. Mean of background noise for each matrix.}

\item{theta}{Numeric vector. Dispersion parameters of the negative
binomial distribution for each matrix. Smaller \code{theta} implies
higher overdispersion.}

\item{pi}{Numeric vector. Probability of excess zeros (\code{0 < pi < 1})
for each matrix.}

\item{kmat}{Integer. Number of count matrices to simulate. Default is 1.}

\item{depth_range}{Numeric vector of length 2 or \code{NA}. Range of total
sequencing depth per cell. If \code{NA}, no depth adjustment is
performed.}
}
\value{
A list containing \code{kmat} matrices. Each matrix has:
\itemize{
\item Rows representing cells (\code{cell_1, ..., cell_n}).
\item Columns representing genes (\code{rownames(B)}).
\item Count values following a ZINB distribution.
}
}
\description{
Simulates one or more count matrices following a zero-inflated negative
binomial (ZINB) distribution, incorporating gene-gene interaction
structures and cell-specific sequencing depth variation.
}
\details{
Each simulated matrix:
\enumerate{
\item Generates gene expression values based on a ZINB model.
\item Modulates expression using the adjacency matrix \code{B}.
\item Applies random sequencing depth scaling if
\code{depth_range} is provided.
}

Useful for benchmarking single-cell RNA-seq network inference methods
with dropout events and network structure.
}
\examples{
data(toy_adj_matrix)
nodes <- nrow(toy_adj_matrix)
sims <- zinb_simdata(
    n = 50,
    p = nodes,
    B = toy_adj_matrix,
    mu_range = list(c(1, 4), c(1, 7), c(1, 10)),
    mu_noise = c(1, 3, 5),
    theta = c(1, 0.7, 0.5),
    pi = c(0.2, 0.2, 0.2),
    kmat = 3,
    depth_range = c(0.8 * nodes * 3, 1.2 * nodes * 3)
)
}
