% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotg.R
\name{plotg}
\alias{plotg}
\title{Visualize Graphs from Adjacency Matrices}
\usage{
plotg(adj_matrix_list)
}
\arguments{
\item{adj_matrix_list}{A list of square, symmetric adjacency matrices
with zeros on the diagonal (no self-loops), or a
\linkS4class{SummarizedExperiment} object containing such matrices as
assays. Each matrix represents an undirected graph.}
}
\value{
A grid of plots displaying all valid graphs in the input list.
}
\description{
Generates and arranges multiple graph visualizations from a list of
adjacency matrices. Each matrix is converted into an undirected
\pkg{igraph} object and visualized using a force-directed layout via
\pkg{ggraph}.
}
\details{
Each adjacency matrix is validated to ensure it is square and
symmetric. Disconnected nodes (degree zero) are removed prior to
visualization. Graphs are visualized with a force-directed layout
using \pkg{ggraph}, and multiple plots are arranged into a grid with
\pkg{gridExtra}.

Each subplot title includes the graph index, number of nodes, and
number of edges.
}
\note{
This function requires the following packages:
\pkg{igraph}, \pkg{ggraph}, and \pkg{gridExtra}. If any are missing,
an informative error will be thrown.
}
\examples{
data(toy_counts)


# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)
head(networks[[1]])

# Generate adjacency matrices
wadj_se <- generate_adjacency(networks)
swadj_se <- symmetrize(wadj_se, weight_function = "mean")

# Apply cutoff
binary_se <- cutoff_adjacency(
    count_matrices = toy_counts,
    weighted_adjm_list = swadj_se,
    n = 1,
    method = "GENIE3",
    quantile_threshold = 0.95,
    nCores = 1,
    debug = TRUE
)
head(binary_se[[1]])
plotg(binary_se)
}
