% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/earlyj.R
\name{earlyj}
\alias{earlyj}
\title{Modify Cell Names and Combine Datasets}
\usage{
earlyj(input_list, rowg = TRUE)
}
\arguments{
\item{input_list}{A \linkS4class{MultiAssayExperiment} object containing
expression data from multiple experiments or conditions.}

\item{rowg}{Logical. If \code{TRUE} (default), genes are assumed to be rows
and cells columns.
If \code{FALSE}, matrices are transposed before renaming and combining.}
}
\value{
A \linkS4class{MultiAssayExperiment} object containing a single merged
experiment with modified (unique) cell names.
}
\description{
Extracts expression data from a \linkS4class{MultiAssayExperiment} object,
modifies cell identifiers by appending a unique experiment index
(e.g., "-m1", "-m2", etc.), and merges the datasets into a single object.
}
\details{
For matrices, this function optionally transposes the input before combining.
For \code{Seurat} and \code{SingleCellExperiment} objects, only features
(genes) common across all input datasets are retained before merging.
The cell names are suffixed with "-m1", "-m2", etc., according to their
original list position. The result is returned as a MultiAssayExperiment
with a single merged experiment.
}
\examples{
data(toy_counts)

merged_mae <- earlyj(toy_counts)
merged_mae

}
