% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_community_metrics.R
\name{compute_community_metrics}
\alias{compute_community_metrics}
\title{Compute Community Assignment Similarity Metrics}
\usage{
compute_community_metrics(control_output, predicted_list)
}
\arguments{
\item{control_output}{A list output from \code{community_path()} representing the
ground truth network. Must contain \code{communities$membership}.}

\item{predicted_list}{A list of lists, each output from \code{community_path()}
representing predicted networks to compare.}
}
\value{
A data frame with columns VI, NMI, and ARI for each prediction.
Row names indicate which prediction (e.g., "Predicted_1").
}
\description{
Calculates community assignment similarity between a reference
community structure and one or more predicted structures using
variation of information (VI), normalized mutual information (NMI),
and adjusted Rand index (ARI).
}
\details{
This function requires the \strong{igraph} package. Lower VI
values indicate better similarity (VI = 0 is perfect match). Higher
NMI and ARI values indicate better similarity (both range 0-1).
}
\examples{
data(toy_counts)
data(toy_adj_matrix)


# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)

# Generate adjacency matrices
wadj_se <- generate_adjacency(networks)
swadj_se <- symmetrize(wadj_se, weight_function = "mean")

# Apply cutoff
binary_se <- cutoff_adjacency(
    count_matrices = toy_counts,
    weighted_adjm_list = swadj_se,
    n = 1,
    method = "GENIE3",
    quantile_threshold = 0.95,
    nCores = 1
)

consensus <- create_consensus(binary_se, method = "union")
comm_cons <- community_path(consensus)
comm_truth <- community_path(toy_adj_matrix)

metrics <- compute_community_metrics(comm_truth, list(comm_cons))
}
