% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DimReduction.R
\name{tSNE}
\alias{tSNE}
\title{tSNE}
\usage{
tSNE(
  expression.mat = NULL,
  topgenes = 1500,
  scale = TRUE,
  thet = 0.5,
  perp = 30
)
}
\arguments{
\item{expression.mat}{An expression matrix, with genes in rows}

\item{topgenes}{number of genes used for clustering calculations.}

\item{scale}{a logical of whether we want to scale the matrix}

\item{thet}{numeric; Speed/accuracy trade-off (increase for less accuracy)}

\item{perp}{numeric; Perplexity parameter
(should not be bigger than 3 * perplexity < nrow(X) - 1, see details for 
interpretation)}
}
\value{
a tSNE reduced matrix containing three tSNE dimensions
}
\description{
calculate tSNE from top variable genes
}
\examples{
day2 <- day_2_cardio_cell_sample
mixedpop1 <-new_scGPS_object(ExpressionMatrix = day2$dat2_counts, 
    GeneMetadata = day2$dat2geneInfo, CellMetadata = day2$dat2_clusters)
t <-tSNE(expression.mat = assay(mixedpop1))

}
