% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORE_clustering.R
\name{find_optimal_stability}
\alias{find_optimal_stability}
\title{Find the optimal cluster}
\usage{
find_optimal_stability(
  list_clusters,
  run_RandIdx,
  bagging = FALSE,
  windows = seq(from = 0.025, to = 1, by = 0.025)
)
}
\arguments{
\item{list_clusters}{is a \code{list} object containing 40 clustering results}

\item{run_RandIdx}{is a \code{data frame} object from iterative clustering 
runs}

\item{bagging}{is a logical that is true if bagging is to be performed, 
changes return}

\item{windows}{a numeric vector specifying the ranges of each window.}
}
\value{
bagging == FALSE => a \code{list} with optimal stability, cluster 
count and summary stats bagging == TRUE => a \code{list} with high res 
cluster count, optimal cluster count and keystats
}
\description{
from calculated stability based on Rand indexes for consecutive
clustering run, find the resolution (window), where the stability is the 
highest
}
\examples{
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_summarized_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
cluster_all <-clustering(object=mixedpop2)
stab_df <- find_stability(list_clusters=cluster_all$list_clusters,
                         cluster_ref = cluster_all$cluster_ref)
optimal_stab <- find_optimal_stability(list_clusters = 
    cluster_all$list_clusters, stab_df, bagging = FALSE)

}
\author{
Quan Nguyen, 2017-11-25
}
