% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainLassoLDATraining.R
\name{bootstrap_prediction}
\alias{bootstrap_prediction}
\title{BootStrap runs for both scGPS training and prediction}
\usage{
bootstrap_prediction(
  nboots = 1,
  genes = genes,
  mixedpop1 = mixedpop1,
  mixedpop2 = mixedpop2,
  c_selectID = NULL,
  listData = list(),
  cluster_mixedpop1 = NULL,
  cluster_mixedpop2 = NULL,
  trainset_ratio = 0.5,
  LDA_run = TRUE,
  verbose = FALSE,
  log_transform = FALSE
)
}
\arguments{
\item{nboots}{a number specifying how many bootstraps to be run}

\item{genes}{a gene list to build the model}

\item{mixedpop1}{a \linkS4class{SingleCellExperiment} object from a mixed 
population for training}

\item{mixedpop2}{a \linkS4class{SingleCellExperiment} object from a target 
mixed population for prediction}

\item{c_selectID}{the root cluster in mixedpop1 to becompared to clusters in
mixedpop2}

\item{listData}{a \code{list} object, which contains trained results for the
first mixed population}

\item{cluster_mixedpop1}{a vector of cluster assignment for mixedpop1}

\item{cluster_mixedpop2}{a vector of cluster assignment for mixedpop2}

\item{trainset_ratio}{a number specifying the proportion of cells to be part 
of the training subpopulation}

\item{LDA_run}{logical, if the LDA prediction is added to compare to 
ElasticNet}

\item{verbose}{a logical whether to display additional messages}

\item{log_transform}{boolean whether log transform should be computed}
}
\value{
a \code{list} with prediction results written in to the index 
\code{out_idx}
}
\description{
ElasticNet and LDA prediction for each of all the 
subpopulations in the new mixed population after training the model for a 
subpopulation in the first mixed population. The number of bootstraps to be 
run can be specified.
}
\examples{
day2 <- day_2_cardio_cell_sample
mixedpop1 <-new_scGPS_object(ExpressionMatrix = day2$dat2_counts, 
    GeneMetadata = day2$dat2geneInfo, CellMetadata = day2$dat2_clusters)
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
genes <-training_gene_sample
genes <-genes$Merged_unique
cluster_mixedpop1 <- colData(mixedpop1)[,1]
cluster_mixedpop2 <- colData(mixedpop2)[,1]
c_selectID <- 2
test <- bootstrap_prediction(nboots = 1, mixedpop1 = mixedpop1, 
    mixedpop2 = mixedpop2, genes=genes, listData =list(), 
    cluster_mixedpop1 = cluster_mixedpop1, 
    cluster_mixedpop2 = cluster_mixedpop2, c_selectID = c_selectID)
names(test)
test$ElasticNetPredict
test$LDAPredict
}
\seealso{
\code{\link{bootstrap_parallel}} for parallel options
}
\author{
Quan Nguyen, 2017-11-25
}
