% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainLassoLDATraining.R
\name{bootstrap_parallel}
\alias{bootstrap_parallel}
\title{BootStrap runs for both scGPS training and prediction
with parallel option}
\usage{
bootstrap_parallel(
  ncores = 4,
  nboots = 1,
  genes = genes,
  mixedpop1 = mixedpop1,
  mixedpop2 = mixedpop2,
  c_selectID,
  listData = list(),
  cluster_mixedpop1 = NULL,
  cluster_mixedpop2 = NULL
)
}
\arguments{
\item{ncores}{a number specifying how many cpus to be used for running}

\item{nboots}{a number specifying how many bootstraps to be run}

\item{genes}{a gene list to build the model}

\item{mixedpop1}{a \linkS4class{SingleCellExperiment} object from a mixed 
population for training}

\item{mixedpop2}{a \linkS4class{SingleCellExperiment} object from a target 
mixed population for prediction}

\item{c_selectID}{the root cluster in mixedpop1 to becompared to clusters in
mixedpop2}

\item{listData}{a \code{list} object, which contains trained results for the
first mixed population}

\item{cluster_mixedpop1}{a vector of cluster assignment for mixedpop1}

\item{cluster_mixedpop2}{a vector of cluster assignment for mixedpop2}
}
\value{
a \code{list} with prediction results written in to the index 
\code{out_idx}
}
\description{
same as bootstrap_prediction, but with an multicore option
}
\examples{
day2 <- day_2_cardio_cell_sample
mixedpop1 <-new_scGPS_object(ExpressionMatrix = day2$dat2_counts, 
    GeneMetadata = day2$dat2geneInfo, CellMetadata = day2$dat2_clusters)
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
genes <-training_gene_sample
genes <-genes$Merged_unique
#prl_boots <- bootstrap_parallel(ncores = 4, nboots = 1, genes=genes,
#    mixedpop1 = mixedpop2, mixedpop2 = mixedpop2,  c_selectID=1,
#    listData =list())
#prl_boots[[1]]$ElasticNetPredict
#prl_boots[[1]]$LDAPredict

}
\author{
Quan Nguyen, 2017-11-25
}
