% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{annotate_clusters}
\alias{annotate_clusters}
\title{annotate_clusters functionally annotates the identified clusters}
\usage{
annotate_clusters(
  DEgeneList,
  pvalueCutoff = 0.05,
  gene_symbol = TRUE,
  species = "human"
)
}
\arguments{
\item{DEgeneList}{is a vector of gene symbols, convertable to ENTREZID}

\item{pvalueCutoff}{is a numeric of the cutoff p value}

\item{gene_symbol}{logical of whether the geneList is a gene symbol}

\item{species}{is the selection of 'human' or 'mouse', default to 'human' 
genes}
}
\value{
write enrichment test output to a file and an enrichment test object 
for plotting
}
\description{
often we need to label clusters with unique biological 
characters. One of the common approach to annotate a cluster is to perform 
functional enrichment analysis. The annotate implements ReactomePA and
clusterProfiler for this analysis type in R. The function require 
installation of several databases as described below.
}
\examples{
genes <-training_gene_sample
genes <-genes$Merged_unique[seq_len(50)]
enrichment_test <- annotate_clusters(genes, pvalueCutoff=0.05, 
    gene_symbol=TRUE, species = 'human')
clusterProfiler::dotplot(enrichment_test, showCategory=15)

}
