% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORE_clustering.R
\name{CORE_subcluster}
\alias{CORE_subcluster}
\title{sub_clustering (optional) after running CORE 'test'}
\usage{
CORE_subcluster(
  mixedpop = NULL,
  windows = seq(from = 0.025, to = 1, by = 0.025),
  select_cell_index = NULL,
  ngenes = 1500
)
}
\arguments{
\item{mixedpop}{is a \linkS4class{SingleCellExperiment} object from the train
mixed population}

\item{windows}{a numeric specifying the number of windows to test}

\item{select_cell_index}{a vector containing indexes for cells in selected 
clusters to be reclustered}

\item{ngenes}{number of genes used for clustering calculations.}
}
\value{
a \code{list} with clustering results of all iterations, and a 
selected optimal resolution
}
\description{
CORE_subcluster allows re-cluster the CORE clustering 
result
}
\examples{
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_summarized_scGPS_object(ExpressionMatrix = day5$dat5_counts,
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
test <- CORE_clustering(mixedpop2,remove_outlier= c(0))
}
\author{
Quan Nguyen, 2017-11-25
}
