% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.regressPCObject.R
\name{plotCoefficientHeatmap}
\alias{plotCoefficientHeatmap}
\title{Generate Regression Coefficients Heatmap}
\usage{
plotCoefficientHeatmap(x, alpha = 0.05, coefficients_include = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{regressPCObject} containing regression results
from \code{regressPC} function.}

\item{alpha}{Numeric value specifying the significance threshold for p-value
adjustment. Default is 0.05.}

\item{coefficients_include}{Character vector specifying which coefficient types to include.
Options are \code{c("cell_type", "batch", "interaction")}. Default is \code{NULL},
which includes all available coefficient types.}

\item{...}{Additional arguments passed to the plotting function (currently unused).}
}
\value{
A \code{ggplot2} object representing the regression coefficients heatmap
  with faceted organization and significance annotations.
}
\description{
Creates a heatmap visualization of regression coefficients from principal component
regression analysis, organized by coefficient type (cell type, batch, interaction)
and annotated with significance indicators.
}
\details{
This function generates a comprehensive heatmap showing regression coefficients
for each principal component and model term. The visualization includes:
\itemize{
  \item Color-coded coefficient values (blue = negative, red = positive)
  \item Significance indicators (asterisks) for adjusted p-values below threshold
  \item Faceted organization by coefficient category (Cell Type, Batch, Interaction)
  \item Clean term labels with proper formatting and reference category information
}

The function handles different model types automatically:
\itemize{
  \item Simple cell type models: \code{PC ~ cell_type}
  \item Batch interaction models: \code{PC ~ cell_type * batch}
  \item Dataset interaction models: \code{PC ~ cell_type * dataset}
}

Term labels are cleaned and formatted for better readability, with batch/dataset
terms converted to consistent "Query Batch" terminology. The plot includes
comprehensive subtitle information showing model specification, significance
threshold, and reference categories.
}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
\keyword{internal}
